/*
 * AddAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Actions/AtomAction/AddAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "atom.hpp"
#include "element.hpp"
#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

const char AtomAddAction::NAME[] = "add-atom";

AtomAddAction::AtomAddAction() :
  Action(NAME)
{}

AtomAddAction::~AtomAddAction()
{}

void AtomAdd(element *elemental, Vector &position) {
  ValueStorage::getInstance().setCurrentValue(AtomAddAction::NAME, elemental);
  ValueStorage::getInstance().setCurrentValue("position", elemental);
  ActionRegistry::getInstance().getActionByName(AtomAddAction::NAME)->call(Action::NonInteractive);
};

Dialog * AtomAddAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryElement(NAME, ValueStorage::getInstance().getDescription(NAME));
  dialog->queryVector("position", true, ValueStorage::getInstance().getDescription("position"));

  return dialog;
}

Action::state_ptr AtomAddAction::performCall() {
  const element * elemental = NULL;
  Vector position;

  // obtain information
  ValueStorage::getInstance().queryCurrentValue(NAME, elemental);
  ValueStorage::getInstance().queryCurrentValue("position", position);

  // execute action
  atom * first = World::getInstance().createAtom();
  first->setType(elemental);
  first->setPosition(position);
  DoLog(1) && (Log() << Verbose(1) << "Adding new atom with element " << first->getType()->getName() << " at " << (first->getPosition()) << "." << endl);
  // TODO: remove when all of World's atoms are stored.
  std::vector<molecule *> molecules = World::getInstance().getAllMolecules();
  if (!molecules.empty()) {
    std::vector<molecule *>::iterator iter = molecules.begin();
    (*iter)->AddAtom(first);
  }
  return Action::success;
}

Action::state_ptr AtomAddAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr AtomAddAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool AtomAddAction::canUndo() {
  return false;
}

bool AtomAddAction::shouldUndo() {
  return false;
}

const string AtomAddAction::getName() {
  return NAME;
}
