/*
 * NonConvexEnvelopeAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/TesselationAction/NonConvexEnvelopeAction.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

#include "boundary.hpp"
#include "linkedcell.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "World.hpp"

/****** TesselationNonConvexEnvelopeAction *****/

// memento to remember the state when undoing

//class TesselationNonConvexEnvelopeState : public ActionState {
//public:
//  TesselationNonConvexEnvelopeState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char TesselationNonConvexEnvelopeAction::NAME[] = "nonconvex-envelope";

TesselationNonConvexEnvelopeAction::TesselationNonConvexEnvelopeAction() :
  Action(NAME)
{}

TesselationNonConvexEnvelopeAction::~TesselationNonConvexEnvelopeAction()
{}

Dialog* TesselationNonConvexEnvelopeAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryEmpty(NAME, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryString("nonconvex-file", MapOfActions::getInstance().getDescription("nonconvex-file"));
  dialog->queryDouble("sphere-radius", MapOfActions::getInstance().getDescription("sphere-radius"));

  return dialog;
}

Action::state_ptr TesselationNonConvexEnvelopeAction::performCall() {
  string filename;
  molecule * Boundary = NULL;
  double SphereRadius = 0;
  bool Success = false;
  clock_t start,end;

  ValueStorage::getInstance().queryCurrentValue("nonconvex-file", filename);
  ValueStorage::getInstance().queryCurrentValue("sphere-radius", SphereRadius);

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    Boundary = iter->second;
    class Tesselation *T = NULL;
    const LinkedCell *LCList = NULL;
    DoLog(0) && (Log() << Verbose(0) << "Evaluating non-convex envelope of molecule." << Boundary->getId() << endl);
    DoLog(1) && (Log() << Verbose(1) << "Using rolling ball of radius " << SphereRadius << " and storing tecplot data in " << filename << "." << endl);
    DoLog(1) && (Log() << Verbose(1) << "Specified molecule has " << Boundary->getAtomCount() << " atoms." << endl);
    start = clock();
    LCList = new LinkedCell(Boundary, SphereRadius*2.);
    Success = FindNonConvexBorder(Boundary, T, LCList, SphereRadius, filename.c_str());
    //FindDistributionOfEllipsoids(T, &LCList, N, number, filename.c_str());
    end = clock();
    DoLog(0) && (Log() << Verbose(0) << "Clocks for this operation: " << (end-start) << ", time: " << ((double)(end-start)/CLOCKS_PER_SEC) << "s." << endl);
    delete(LCList);
    delete(T);
  }
  if (Success)
    return Action::success;
  else
    return Action::failure;
}

Action::state_ptr TesselationNonConvexEnvelopeAction::performUndo(Action::state_ptr _state) {
//  TesselationNonConvexEnvelopeState *state = assert_cast<TesselationNonConvexEnvelopeState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr TesselationNonConvexEnvelopeAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool TesselationNonConvexEnvelopeAction::canUndo() {
  return false;
}

bool TesselationNonConvexEnvelopeAction::shouldUndo() {
  return false;
}

const string TesselationNonConvexEnvelopeAction::getName() {
  return NAME;
}
