/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the COPYING file or "Copyright notice" in builder.cpp for details.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>. 
 */

/*
 * HomologyGraph_getFromKeysetStub.cpp
 *
 *  Created on: Sep 25, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Fragmentation/Homology/HomologyGraph.hpp"
#include "Fragmentation/KeySet.hpp"
#include "Fragmentation/Summation/IndexSet.hpp"

namespace detail {

  const HomologyGraph::nodes_t getNodesFromKeySet(const KeySet &keyset)
  {
    return HomologyGraph::nodes_t();
  }

  const HomologyGraph::edges_t getEdgesFromKeySet(const KeySet &keyset)
  {
    return HomologyGraph::edges_t();
  }

  const HomologyGraph::nodes_t getNodesFromIndexSet(const IndexSet &keyset)
  {
    return HomologyGraph::nodes_t();
  }

  const HomologyGraph::edges_t getEdgesFromIndexSet(const IndexSet &keyset)
  {
    return HomologyGraph::edges_t();
  }

};  /* namespace detail */
