/*
 * XyzParser.hpp
 *
 *  Created on: Mar 2, 2010
 *      Author: metzler
 */

#ifndef XYZPARSER_HPP_
#define XYZPARSER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>


#include "FormatParser.hpp"
#include "FormatParserTrait.hpp"
#include "FormatParserInterface.hpp"
#include "FormatParser_common.hpp"
#include "ParserTypes.hpp"

// declaration of specialized FormatParserTrait
template<>
struct FormatParserTrait<xyz>
{
  //!> Name of the parser
  static const std::string name;
  //!> suffix of the files the parser understands to read and write
  static const std::string suffix;
  //!> ParserTypes enumeration for the parser
  static const enum ParserTypes type;
};

/**
 * Parser for XYZ files.
 */
template <>
class FormatParser< xyz >  : virtual public FormatParserInterface, public FormatParser_common
{
public:
  FormatParser();
  virtual ~FormatParser();
  void load(std::istream* file);
  void save(std::ostream* file, const std::vector<const atom *> &atoms);

private:
  static const std::string printCoordinate(const double value);

private:
  std::string comment;
};

#endif /* XYZPARSER_HPP_ */
