/*
 * Psi3Parser.hpp
 *
 *  Created on: Oct 04, 2011
 *      Author: heber
 */

#ifndef PSI3PARSER_HPP_
#define PSI3PARSER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/toString.hpp"

#include "FormatParser.hpp"
#include "FormatParserTrait.hpp"
#include "FormatParserInterface.hpp"
#include "FormatParser_common.hpp"
#include "ParserTypes.hpp"

#include "Psi3Parser_Parameters.hpp"

#include <iosfwd>

class Vector;

// declaration of specialized FormatParserTrait
template<>
struct FormatParserTrait<psi3>
{
  //!> Name of the parser
  static const std::string name;
  //!> suffix of the files the parser understands to read and write
  static const std::string suffix;
  //!> ParserTypes enumeration for the parser
  static const enum ParserTypes type;
};

/**
 * Loads a PSI3 config file into the World and saves the World as a tremolo file.
 */
template <>
class FormatParser< psi3 >  : virtual public FormatParserInterface, public FormatParser_common
{
  friend class ParserPsi3UnitTest;
public:
  FormatParser();
  virtual ~FormatParser();

  void load(std::istream *file);
  void save(std::ostream *file, const std::vector<const atom *> &atoms);

  /** Getter for parameter set.
   *
   * @return reference to parameter class
   */
  Psi3Parser_Parameters & getParams() { return *static_cast<Psi3Parser_Parameters *>(parameters); }

private:
  /** Prints the config line for the given \a _atom in PSI3 style.
   *
   * \param out output stream
   * \param _atom atom to print
   * \param center correct atom position by this vector
   */
  void OutputPsi3Line(std::ostream * const out, const atom &_atom, const Vector *center) const;

  /** Calculates multiplicites for a given set of \a atoms.
   *
   * \param atoms set of atoms
   * \return mulitplicity
   */
  unsigned int calculateMultiplicity(const std::vector<const atom *> &atoms) const;

  static ConvertTo<bool> Converter;
};


#endif /* PSI3PARSER_HPP_ */
