/*
 * PcpParser.hpp
 *
 *  Created on: 12.06.2010
 *      Author: heber
 */

#ifndef PCPPARSER_HPP_
#define PCPPARSER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <map>
#include <string>
#include <vector>

#include "FormatParser.hpp"
#include "FormatParserTrait.hpp"
#include "FormatParserInterface.hpp"
#include "FormatParser_common.hpp"
#include "ParserTypes.hpp"

class atom;

// declaration of specialized FormatParserTrait
template<>
struct FormatParserTrait<pcp>
{
  //!> Name of the parser
  static const std::string name;
  //!> suffix of the files the parser understands to read and write
  static const std::string suffix;
  //!> ParserTypes enumeration for the parser
  static const enum ParserTypes type;
};

/**
 * Parser for PCP config files.
 */
template <>
class FormatParser< pcp >  : virtual public FormatParserInterface, public FormatParser_common
{
public:
  FormatParser();
  virtual ~FormatParser();
  void load(std::istream* file);
  void save(std::ostream* file, const std::vector<const atom *> &atoms);

  bool operator==(const FormatParser< pcp >& b) const;

private:

  void ParseThermostats(class ConfigFileBuffer * const fb);
  void OutputAtoms(
      std::ostream *file,
      const std::vector<const atom *> &allatoms,
      std::map<int, int> &ZtoIndexMap);
  void OutputElements(
      std::ostream *file,
      const std::vector<const atom *> &allatoms,
      std::map<int, int> &ZtoIndexMap);
  void CalculateOrbitals(
      const std::vector<const atom *> &allatoms);

  class StructParallelization {
  public:
    StructParallelization();
    ~StructParallelization();

    int ProcPEGamma;
    int ProcPEPsi;
  } Parallelization;

  /*
   * Contains all the paths and names
   */
  class StructPaths {
  public:
    StructPaths();
    ~StructPaths();

    char *databasepath;
    char *configname;
    char *mainname;
    char *defaultpath;
    char *pseudopotpath;
  } Paths;

  /*
   * Contains all Do/Don't switches
   */
  class StructSwitches {
  public:
    StructSwitches();
    ~StructSwitches();

    int DoConstrainedMD;
    int DoOutVis;
    int DoOutMes;
    int DoOutNICS;
    int DoOutOrbitals;
    int DoOutCurrent;
    int DoFullCurrent;
    int DoPerturbation;
    int DoWannier;
  } Switches;

  /*
   * Contains parameters regarding localization of orbitals or magnetic perturbation
   */
  class StructLocalizedOrbitals {
  public:
    StructLocalizedOrbitals();
    ~StructLocalizedOrbitals();

    int CommonWannier;
    double SawtoothStart;
    int VectorPlane;
    double VectorCut;
    int UseAddGramSch;
    int Seed;
    double EpsWannier;
  } LocalizedOrbitals;

  /*
   * Contains all step count and other epsilon threshold parameters
   */
  class StructStepCounts {
  public:
    StructStepCounts();
    ~StructStepCounts();

    int MaxMinStopStep;
    int InitMaxMinStopStep;

    int OutVisStep;
    int OutSrcStep;
    int MaxPsiStep;

    int MaxOuterStep;

    int MaxMinStep;
    double RelEpsTotalEnergy;
    double RelEpsKineticEnergy;
    int MaxMinGapStopStep;
    int MaxInitMinStep;
    double InitRelEpsTotalEnergy;
    double InitRelEpsKineticEnergy;
    int InitMaxMinGapStopStep;
  } StepCounts;

  /*
   * Contains all parameters specific to the plane wave basis set
   */
  class StructPlaneWaveSpecifics {
  public:
    StructPlaneWaveSpecifics();
    ~StructPlaneWaveSpecifics();

    int PsiType;
    int MaxPsiDouble;
    int PsiMaxNoUp;
    int PsiMaxNoDown;
    double ECut;
    int MaxLevel;
    int RiemannTensor;
    int LevRFactor;
    int RiemannLevel;
    int Lev0Factor;
    int RTActualUse;
    int AddPsis;
    double RCut;
  } PlaneWaveSpecifics;

  bool FastParsing;

  double Deltat;
  int IsAngstroem;
  int RelativeCoord;
  int StructOpt;
  int MaxTypes;
  std::string basis;
};

#endif /* PCPPARSER_HPP_ */
