/*
 * FormatParserInterface.hpp
 *
 *  Created on: Sep 27, 2011
 *      Author: heber
 */

#ifndef FORMATPARSERINTERFACE_HPP_
#define FORMATPARSERINTERFACE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <string>
#include <vector>

#include "ParserTypes.hpp"
#include "types.hpp"

class atom;
class FormatParser_Parameters;

/**
 * Interface definition for a general parser.
 *
 * In order to allow storage and common interface to all FormatParser
 * specialization variants, we need this interface definition.
 */
class FormatParserInterface {
public:
  FormatParserInterface() {}
  virtual ~FormatParserInterface() {}
  virtual void save(std::ostream* file, const std::vector<const atom *> &atoms)=0;
  virtual void load(std::istream* file)=0;
  virtual void setOstream(std::ostream* file)=0;

  FormatParser_Parameters *parameters;
protected:
  // these functions are called when atoms are inserted or removed
  virtual void AtomInserted(atomId_t)=0;
  virtual void AtomRemoved(atomId_t)=0;
};


#endif /* FORMATPARSERINTERFACE_HPP_ */
