/*
 * FormatParser.hpp
 *
 *  Created on: Mar 1, 2010
 *      Author: metzler
 */

#ifndef FORMATPARSER_HPP_
#define FORMATPARSER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <string>
#include <vector>

#include "CodePatterns/Assert.hpp"

#include "FormatParserTrait.hpp"
#include "FormatParserInterface.hpp"
#include "FormatParser_common.hpp"
#include "ParserTypes.hpp"

class atom;

/**
 * @file
 * <H1> FormatParser Howto </H1>
 *
 * <H2> Introduction </H2>
 *
 * FormatParsers parse external streams (files) and bring their information
 * into the World. That is they implement load and save functions that work
 * on a specific vector atoms.
 *
 * <H2> Building your own Parsers </H2>
 *
 * Building Parsers is easy. All you have to do is the following:
 * -# add a new parser type to the file ParserTypes.def.
 * -# add a new template specialization of FormatParser in a new header and
 *    module that implement the virtual load and save functions.
 * -# Add the header file of your new parser to FormatParserStorage.cpp.
 *
 * <H3> Specific notes on the macros </H3>
 *
 * To clarify a bit the internals of all the different FormatParser... files, here
 * are some notes:
 * -# We make use of boost::preprocessor to generate lists from the sequence
 *    given in ParserTypes.def (and undefined in ParserTypes.undef). These might
 *    be forward declarations of even implementations. This is to assure that
 *    none are forgotten when a new FormatParser is added.
 * -# Thanks to the above construct FormatParserStorage also immediately knows
 *    about any new parsers and can get and add such instances.
 */

/**
 * General parser which observes the change tracker.
 */
template <enum ParserTypes Ptype>
class FormatParser : virtual public FormatParserInterface, public FormatParser_common {
  FormatParser() :
    FormatParser_common(NULL)
  {
    ASSERT(0, "FormatParser<>::FormatParser() - unspecialized function cannot be called."); 
  }
  virtual ~FormatParser()
  {
    ASSERT(0, "FormatParser<>::~FormatParser() - unspecialized function cannot be called."); 
  }

  void load(std::istream *file) 
  {
    ASSERT(0, "FormatParser<>::load() - unspecialized function cannot be called."); 
  }
  void save(std::ostream *file, const std::vector<const atom *> &atoms)
  {
    ASSERT(0, "FormatParser<>::save() - unspecialized function cannot be called."); 
  }
};

#include "FormatParser_specializations_header.hpp"

#endif /* FORMATPARSER_HPP_ */
