/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * AtomsTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <Descriptors/AtomDescriptor.hpp>
#include <Descriptors/AtomIdDescriptor.hpp>
#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include "Atom/atom.hpp"
#include "World.hpp"


TextDialog::AtomsTextQuery::AtomsTextQuery(Parameter<std::vector<const atom *> > &_param, const std::string &_title, const std::string &_description) :
    Dialog::TQuery<std::vector<const atom *> >(_param, _title,_description)
{}

TextDialog::AtomsTextQuery::~AtomsTextQuery() {}

bool TextDialog::AtomsTextQuery::handle() {
  int idxOfAtom=-1;
  std::cout << getDescription() << ": ";
  std::string line;
  getline(std::cin,line);
  // dissect by " "
  const atom *temp_element;
  std::string::iterator olditer = line.begin();
  for(std::string::iterator iter = line.begin(); iter != line.end(); ++iter) {
    if (*iter == ' ') {
      std::istringstream stream(std::string(iter, olditer));
      stream >> idxOfAtom;
      temp_element = const_cast<const World &>(World::getInstance()).getAtom(AtomById(idxOfAtom));
      if(!temp_element && idxOfAtom!=-1){
        std::cout << "Invalid Atom Index" << idxOfAtom << std::endl;
        break;
      }
      temp.push_back(temp_element);
      olditer = iter;
    }
  }
  if (olditer != line.begin()) { // insert last part also
    std::istringstream stream(std::string(olditer, line.end()));
    stream >> idxOfAtom;
    temp_element = const_cast<const World &>(World::getInstance()).getAtom(AtomById(idxOfAtom));
    if(!temp_element && idxOfAtom!=-1) {
      std::cout << "Invalid Atom Index" << idxOfAtom << std::endl;
      temp.push_back(temp_element);
    }
  }

  return (idxOfAtom!=-1);
}

