/*
 * memoryallocatorunittest.cpp
 *
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "memoryallocator.hpp"
#include "memoryallocatorunittest.hpp"
#include "memoryusageobserver.hpp"
#include "Helpers/helpers.hpp"
#include "Helpers/Log.hpp"
#include "defs.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( MemoryAllocatorTest );


void MemoryAllocatorTest::setUp()
{
};


void MemoryAllocatorTest::tearDown()
{
  MemoryUsageObserver::getInstance()->purgeInstance();
  logger::purgeInstance();
};

/**
 * UnitTest for Malloc()
 */
void MemoryAllocatorTest::MallocTest()
{
  int* buffer1 = NULL;
  buffer1 = Malloc<int>(1, "");
  Free(&buffer1);

  long* buffer2 = NULL;
  buffer2 = Malloc<long>(1, "");
  Free(&buffer2);

  char* buffer3 = NULL;
  buffer3 = Malloc<char>(4, "");
  DoLog(0) && (Log() << Verbose(0) << buffer3 << endl);
  Free(&buffer3);

  char** buffer4 = NULL;
  buffer4 = Malloc<char*>(10, "");
  for (int i=0;i<10;i++)
    buffer4[i] = NULL;
  Free(&buffer4);
};

/**
 * UnitTest for Calloc()
 */
void MemoryAllocatorTest::CallocTest()
{
  int* buffer1 = NULL;
  buffer1 = Calloc<int>(10, "");
  Free(&buffer1);

  long* buffer2 = NULL;
  buffer2 = Calloc<long>(10, "");
  Free(&buffer2);

  char** buffer3 = NULL;
  buffer3 = Calloc<char *>(10, "");
  for (int i=0;i<10;i++)
    buffer3[i] = NULL;
  Free(&buffer3);
};

/**
 * UnitTest for ReAlloc()
 */
void MemoryAllocatorTest::ReAllocTest()
{
  int* buffer1 = NULL;
  buffer1 = Malloc<int>(1, "");
  buffer1 = ReAlloc<int>(buffer1, 2, "");
  Free(&buffer1);

  int* buffer2 = NULL;
  buffer2 = ReAlloc<int>(buffer2, 2, "");
  Free(&buffer2);
};

/**
 * UnitTest for Free()
 */
void MemoryAllocatorTest::FreeTest()
{
  char** buffer1 = NULL;
  Free(buffer1);

  int** buffer2 = NULL;
  Free(buffer2);
};
