/*
 * ObserverTest.hpp
 *
 *  Created on: Jan 19, 2010
 *      Author: crueger
 */

#ifndef OBSERVERTEST_HPP_
#define OBSERVERTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

// forward declaration for test stubs
class UpdateCountObserver;
class SimpleObservable;
class CallObservable;
class SuperObservable;


class ObserverTest :  public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( ObserverTest ) ;
  CPPUNIT_TEST ( doesUpdateTest );
  CPPUNIT_TEST ( doesBlockUpdateTest );
  CPPUNIT_TEST ( doesSubObservableTest );
  CPPUNIT_TEST ( CircleDetectionTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void doesUpdateTest();
  void doesBlockUpdateTest();
  void doesSubObservableTest();
  void CircleDetectionTest();

private:
  UpdateCountObserver *observer1;
  UpdateCountObserver *observer2;
  UpdateCountObserver *observer3;

  SimpleObservable *simpleObservable;
  CallObservable *callObservable;
  SuperObservable *superObservable;
};

#endif /* OBSERVERTEST_HPP_ */
