/*
 * ChangeElementAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AtomAction/ChangeElementAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Descriptors/AtomIdDescriptor.hpp"
#include "atom.hpp"
#include "element.hpp"
#include "Helpers/Log.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Helpers/Verbose.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <map>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

typedef std::map<int, const element *> ElementMap;

// memento to remember the state when undoing

class AtomChangeElementState : public ActionState {
public:
  AtomChangeElementState(ElementMap _Elements, const element *_elemental) :
    Elements(_Elements),
    elemental(_elemental)
  {}
  ElementMap Elements;
  const element *elemental;
};

const char AtomChangeElementAction::NAME[] = "change-element";

AtomChangeElementAction::AtomChangeElementAction() :
  Action(NAME)
{}

AtomChangeElementAction::~AtomChangeElementAction()
{}

void AtomChangeElement(element *elemental) {
  ValueStorage::getInstance().setCurrentValue(AtomChangeElementAction::NAME, elemental);
  ActionRegistry::getInstance().getActionByName(AtomChangeElementAction::NAME)->call(Action::NonInteractive);
};

Dialog* AtomChangeElementAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryElement(NAME, ValueStorage::getInstance().getDescription(NAME));

return dialog;
}

Action::state_ptr AtomChangeElementAction::performCall() {
  atom *first = NULL;
  const element *elemental;
  molecule *mol = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, elemental);

  // create undo state
  ElementMap Elements;
  for (World::AtomSelectionIterator iter = World::getInstance().beginAtomSelection(); iter != World::getInstance().endAtomSelection(); ++iter) {
    Elements.insert(std::pair<int, const element *> (iter->second->getId(), iter->second->getType()));
  }
  AtomChangeElementState *UndoState = new AtomChangeElementState(Elements, elemental);

  for (World::AtomSelectionIterator iter = World::getInstance().beginAtomSelection(); iter != World::getInstance().endAtomSelection(); ++iter) {
    first = iter->second;
    DoLog(1) && (Log() << Verbose(1) << "Changing atom " << *first << " to element " << *elemental << "." << endl);
    mol = first->getMolecule();
    first->removeFromMolecule(); // remove atom
    first->setType(elemental);
    mol->AddAtom(first);  // add atom to ensure correctness of formula
  }
  return Action::state_ptr(UndoState);
}

Action::state_ptr AtomChangeElementAction::performUndo(Action::state_ptr _state) {
  AtomChangeElementState *state = assert_cast<AtomChangeElementState*>(_state.get());
  atom *first = NULL;
  molecule *mol = NULL;

  for(ElementMap::const_iterator iter = state->Elements.begin(); iter != state->Elements.end(); ++iter) {
    first = World::getInstance().getAtom(AtomById(iter->first));
    mol = first->getMolecule();
    first->removeFromMolecule(); // remove atom
    first->setType(iter->second);
    mol->AddAtom(first);  // add atom to ensure correctness of formula
  }

  return Action::state_ptr(_state);
}

Action::state_ptr AtomChangeElementAction::performRedo(Action::state_ptr _state){
  AtomChangeElementState *state = assert_cast<AtomChangeElementState*>(_state.get());
  atom *first = NULL;
  molecule *mol = NULL;

  for(ElementMap::const_iterator iter = state->Elements.begin(); iter != state->Elements.end(); ++iter) {
    first = World::getInstance().getAtom(AtomById(iter->first));
    mol = first->getMolecule();
    first->removeFromMolecule(); // remove atom
    first->setType(state->elemental);
    mol->AddAtom(first);  // add atom to ensure correctness of formula
  }

  return Action::state_ptr(_state);
}

bool AtomChangeElementAction::canUndo() {
  return true;
}

bool AtomChangeElementAction::shouldUndo() {
  return true;
}

const string AtomChangeElementAction::getName() {
  return NAME;
}
