/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * atexit.cpp
 *
 *  Created on: Oct 23, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Chronos.hpp"
#include "CodePatterns/Log.hpp"

/** Cleans all singleton instances in an orderly fashion.
 * C++ does not guarantee any specific sequence of removal of single instances
 * which have static/global variables. Some singletons depend on others hence we
 * acertain a specific ordering here, which is is used via the atexit() hook.
 */
void cleanUp()
{
  Chronos::purgeInstance();
  logger::purgeInstance();
  errorLogger::purgeInstance();;
  Memory::getState();
}
