/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * Inserter.cpp
 *
 *  Created on: Feb 21, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Inserter.hpp"

#include "InserterBase.hpp"

/** Constructor for class Inserter.
 *
 * @param _impl implementation to wrap
 */
Inserter::Inserter(Inserter::impl_ptr _impl) :
    impl(_impl)
{}

/** Copy Constructor for class Inserter.
 *
 */
Inserter::Inserter(const Inserter &ptr) :
    impl(ptr.getImpl())
{}

/** Destructor for class Inserter.
 *
 */
Inserter::~Inserter()
{}

void Inserter::operator()(CopyAtomsInterface &copyMethod, ClusterInterface::Cluster_impl cluster, const Vector &offset) const
{
  return impl->operator()(copyMethod, cluster, offset);
}

Inserter::impl_ptr Inserter::getImpl() const {
  return impl;
}
