/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2015 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * DryRunAction.cpp
 *
 *  Created on: May 15, 2015
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "version.h"

#include <sstream>
#include <string>

#include "Actions/CommandAction/DryRunAction.hpp"

#include "Actions/ActionQueue.hpp"
#include "Actions/DryRunAdvocate.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "DryRunAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr CommandDryRunAction::performCall() {
  // set ActionQueue on to last element (hence skipping all in between)
  const bool oldstate = ActionQueue::getInstance().getDryRun();
  DryRunAdvocate::setDryRun(true);
  STATUS("Performing dry run from now on.");

  return ActionState::ptr(new CommandDryRunState(oldstate, params));
}

ActionState::ptr CommandDryRunAction::performUndo(ActionState::ptr _state) {
  CommandDryRunState *state = assert_cast<CommandDryRunState*>(_state.get());
  DryRunAdvocate::setDryRun(state->dryrunstate);
  {
    std::stringstream output;
    output << "Undoing set dry run, is back to " << (state->dryrunstate ? "true" : "false");
    STATUS(output.str());
  }

  return ActionState::ptr(_state);
}

ActionState::ptr CommandDryRunAction::performRedo(ActionState::ptr _state){
  DryRunAdvocate::setDryRun(true);
  STATUS("Redoing set dry run.");

  return ActionState::ptr(_state);
}

bool CommandDryRunAction::canUndo() {
  return true;
}

bool CommandDryRunAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
