/*
 * FormatParser.hpp
 *
 *  Created on: Mar 1, 2010
 *      Author: metzler
 */

#ifndef FORMATPARSER_HPP_
#define FORMATPARSER_HPP_

#include "Patterns/Observer.hpp"
#include "ChangeTracker.hpp"
#include "parser.hpp"

/**
 * General parser which observes the change tracker.
 */
class FormatParser : public Observer {
public:
  FormatParser();
  virtual ~FormatParser();
  virtual void save(std::ostream* file)=0;
  virtual void load(std::istream* file)=0;
  void setOstream(std::ostream* file);
  void update(Observable *publisher);
  void subjectKilled(Observable *publisher);

private:
  std::ostream* saveStream;
};

#endif /* FORMATPARSER_HPP_ */
