/*
 * ObservedIterator.hpp
 *
 *  Created on: Mar 4, 2010
 *      Author: crueger
 */

#ifndef OBSERVEDITERATOR_HPP_
#define OBSERVEDITERATOR_HPP_

#include "Patterns/Observer.hpp"

#include <iterator>

// we build an iterator that observes traversion of some kind of Data structure conforming to STL
template<class _Set>
class ObservedIterator
    : public std::iterator<typename std::iterator_traits<typename _Set::iterator>::iterator_category,
                           typename std::iterator_traits<typename _Set::iterator>::value_type,
                           typename std::iterator_traits<typename _Set::iterator>::difference_type,
                           typename std::iterator_traits<typename _Set::iterator>::pointer,
                           typename std::iterator_traits<typename _Set::iterator>::reference>
{
public:
  // Some typedefs to conform to STL-Iterator structure
  typedef typename _Set::iterator _Iter;
  typedef typename _Iter::value_type value_type;
  typedef typename _Iter::difference_type difference_type;
  typedef typename _Iter::pointer pointer;
  typedef typename _Iter::reference reference;
  typedef typename _Iter::iterator_category iterator_category;

  ObservedIterator() :
    protector(0)
  {}

  ObservedIterator(_Iter iter,Observable *obs) :
    iter(iter)
  {
    // for this we actually get a lock on the heap,
    // so we can copy ourselves
    protector = new Observable::_Observable_protector(obs);
  }

  ObservedIterator(const ObservedIterator &dest) :
    iter(dest.iter)
  {
    protector = new Observable::_Observable_protector(*dest.protector);
  }

  ~ObservedIterator(){
    if(protector)
      delete protector;
  }

  // standard Iterator methods
  ObservedIterator& operator=(const ObservedIterator& dest){
    if(&dest !=this){
      // get the new lock first, in case the two locks point to the same observable
      Observable::_Observable_protector *newLock = new Observable::_Observable_protector(*dest.protector);
      delete protector;
      protector = newLock;
      // After the new lock is aquired we can safely set the iterator
      iter = dest.iter;
    }
    return *this;
  }

  ObservedIterator& operator++()   // prefix
  {
    ++iter;
    return *this;
  }

  ObservedIterator operator++(int) // postfix with the dummy int parameter
  {
    ObservedIterator ret(*this);
    ++(*this);
    return ret;
  }

  ObservedIterator& operator--()   // prefix
  {
    --iter;
  }

  ObservedIterator  operator--(int) // postfix with the dummy int parameter
  {
    ObservedIterator ret(*this);
    --(*this);
    return ret;
  }

  bool operator==(const ObservedIterator &rhs){
    return iter==rhs.iter;
  }

  bool operator!=(const ObservedIterator &rhs){
    return iter!=rhs.iter;
  }

  value_type operator*(){
    return (*iter);
  }

  // when we turn into a const iterator we can loose our lock
  operator typename _Set::const_iterator() {
    // typecast will be handled by the typecast method of the original iterator
    return iter;
  }

private:
  _Iter iter;
  Observable::_Observable_protector *protector;
};

#endif /* OBSERVEDITERATOR_HPP_ */
