/*
 * tesselationunittest.cpp
 *
 *  Created on: Aug 26, 2009
 *      Author: heber
 */


using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <cstring>

#include "defs.hpp"
#include "tesselation.hpp"
#include "tesselationunittest.hpp"

#define SPHERERADIUS 2.

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( TesselationTest );


void TesselationTest::setUp()
{
  // create corners
  class TesselPoint *Walker;
  Walker = new TesselPoint;
  Walker->node = new Vector(1., 0., -1.);
  Walker->Name = Malloc<char>(3, "TesselationTest::setUp");
  strcpy(Walker->Name, "1");
  Walker->nr = 1;
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->node = new Vector(-1., 1., -1.);
  Walker->Name = Malloc<char>(3, "TesselationTest::setUp");
  strcpy(Walker->Name, "2");
  Walker->nr = 2;
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->node = new Vector(-1., -1., -1.);
  Walker->Name = Malloc<char>(3, "TesselationTest::setUp");
  strcpy(Walker->Name, "3");
  Walker->nr = 3;
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->node = new Vector(-1., 0., 1.);
  Walker->Name = Malloc<char>(3, "TesselationTest::setUp");
  strcpy(Walker->Name, "4");
  Walker->nr = 4;
  Corners.push_back(Walker);

  // create linkedcell
  LinkedList = new LinkedCell(&Corners, 2.*SPHERERADIUS);

  // create tesselation
  TesselStruct = new Tesselation;
  CPPUNIT_ASSERT_EQUAL( true, TesselStruct->PointsOnBoundary.empty() );
  CPPUNIT_ASSERT_EQUAL( true, TesselStruct->LinesOnBoundary.empty() );
  CPPUNIT_ASSERT_EQUAL( true, TesselStruct->TrianglesOnBoundary.empty() );
  TesselStruct->FindStartingTriangle(SPHERERADIUS, LinkedList);

  CandidateForTesselation *baseline = NULL;
  BoundaryTriangleSet *T = NULL;
  bool OneLoopWithoutSuccessFlag = true;
  bool TesselationFailFlag = false;
  while ((!TesselStruct->OpenLines.empty()) && (OneLoopWithoutSuccessFlag)) {
    // 2a. fill all new OpenLines
    for (CandidateMap::iterator Runner = TesselStruct->OpenLines.begin(); Runner != TesselStruct->OpenLines.end(); Runner++) {
      baseline = Runner->second;
      if (baseline->pointlist.empty()) {
        T = (((baseline->BaseLine->triangles.begin()))->second);
        TesselationFailFlag = TesselStruct->FindNextSuitableTriangle(*baseline, *T, SPHERERADIUS, LinkedList); //the line is there, so there is a triangle, but only one.
      }
    }

    // 2b. search for smallest ShortestAngle among all candidates
    double ShortestAngle = 4.*M_PI;
    for (CandidateMap::iterator Runner = TesselStruct->OpenLines.begin(); Runner != TesselStruct->OpenLines.end(); Runner++) {
      if (Runner->second->ShortestAngle < ShortestAngle) {
        baseline = Runner->second;
        ShortestAngle = baseline->ShortestAngle;
      }
    }
    if ((ShortestAngle == 4.*M_PI) || (baseline->pointlist.empty()))
      OneLoopWithoutSuccessFlag = false;
    else {
      TesselStruct->AddCandidatePolygon(*baseline, SPHERERADIUS, LinkedList);
    }
  }
};


void TesselationTest::tearDown()
{
  delete(LinkedList);
  delete(TesselStruct);
  for (LinkedCell::LinkedNodes::iterator Runner = Corners.begin(); Runner != Corners.end(); Runner++) {
    delete((*Runner)->node);
    delete(*Runner);
  }
  Corners.clear();
  MemoryUsageObserver::purgeInstance();
  logger::purgeInstance();
  errorLogger::purgeInstance();
};

/** UnitTest for Contains...()
 *
 */
void TesselationTest::ContainmentTest()
{
  class BoundaryPointSet *point = NULL;
  class BoundaryLineSet *line = NULL;

  // check ContainsBoundaryPoint
  for(LineMap::iterator Runner = TesselStruct->LinesOnBoundary.begin(); Runner != TesselStruct->LinesOnBoundary.end(); Runner++) {
    CPPUNIT_ASSERT_EQUAL( true, (Runner->second)->ContainsBoundaryPoint((Runner->second)->endpoints[0]));
    CPPUNIT_ASSERT_EQUAL( true, (Runner->second)->ContainsBoundaryPoint((Runner->second)->endpoints[1]));
  }
  for(TriangleMap::iterator Runner = TesselStruct->TrianglesOnBoundary.begin(); Runner != TesselStruct->TrianglesOnBoundary.end(); Runner++) {
    for(PointMap::iterator PointRunner = TesselStruct->PointsOnBoundary.begin(); PointRunner != TesselStruct->PointsOnBoundary.end(); PointRunner++) {
      point = PointRunner->second;
      for (int i=0;i<3;i++)
        if (point == (Runner->second)->endpoints[i])
          point = NULL;
      if (point != NULL)
        break;
    }
    CPPUNIT_ASSERT_EQUAL( true, (Runner->second)->ContainsBoundaryPoint((Runner->second)->endpoints[0]));
    CPPUNIT_ASSERT_EQUAL( true, (Runner->second)->ContainsBoundaryPoint((Runner->second)->endpoints[1]));
    CPPUNIT_ASSERT_EQUAL( true, (Runner->second)->ContainsBoundaryPoint((Runner->second)->endpoints[2]));
    CPPUNIT_ASSERT_EQUAL( false, (Runner->second)->ContainsBoundaryPoint(point));
  }

  // check ContainsBoundaryLine
  for(TriangleMap::iterator Runner = TesselStruct->TrianglesOnBoundary.begin(); Runner != TesselStruct->TrianglesOnBoundary.end(); Runner++) {
    for(LineMap::iterator LineRunner = TesselStruct->LinesOnBoundary.begin(); LineRunner != TesselStruct->LinesOnBoundary.end(); LineRunner++) {
      line = LineRunner->second;
      for (int i=0;i<3;i++)
        if (line == (Runner->second)->lines[i])
          line = NULL;
      if (line != NULL)
        break;
    }
    CPPUNIT_ASSERT_EQUAL( true, (Runner->second)->ContainsBoundaryLine((Runner->second)->lines[0]));
    CPPUNIT_ASSERT_EQUAL( true, (Runner->second)->ContainsBoundaryLine((Runner->second)->lines[1]));
    CPPUNIT_ASSERT_EQUAL( true, (Runner->second)->ContainsBoundaryLine((Runner->second)->lines[2]));
    CPPUNIT_ASSERT_EQUAL( false, (Runner->second)->ContainsBoundaryLine(line));
  }

  // check IsPresentTupel
  CPPUNIT_ASSERT_EQUAL( true, true );
}

/** UnitTest for Tesselation::GetAllTriangles()
 *
 */
void TesselationTest::GetAllTrianglesTest()
{
  class BoundaryPointSet *Walker = NULL;

  // check that there are three adjacent triangles for every boundary point
  for (PointMap::iterator Runner = TesselStruct->PointsOnBoundary.begin(); Runner != TesselStruct->PointsOnBoundary.end(); Runner++) {
    Walker = Runner->second;
    set<BoundaryTriangleSet*> *triangles = TesselStruct->GetAllTriangles(Walker);
    CPPUNIT_ASSERT_EQUAL( (size_t)3, triangles->size() );
    // check that the returned triangle all contain the Walker
    for (set<BoundaryTriangleSet*>::iterator TriangleRunner = triangles->begin(); TriangleRunner != triangles->end(); TriangleRunner++)
      CPPUNIT_ASSERT_EQUAL( true, (*TriangleRunner)->ContainsBoundaryPoint(Walker) );
    delete(triangles);
  }
}

/********************************************** Main routine **************************************/

int main(int argc, char **argv)
{
  // Get the top level suite from the registry
  CppUnit::Test *suite = CppUnit::TestFactoryRegistry::getRegistry().makeTest();

  // Adds the test to the list of test to run
  CppUnit::TextUi::TestRunner runner;
  runner.addTest( suite );

  // Change the default outputter to a compiler error format outputter
  runner.setOutputter( new CppUnit::CompilerOutputter( &runner.result(),
                                                       std::cerr ) );
  // Run the tests.
  bool wasSucessful = runner.run();

  // Return error code 1 if the one of test failed.
  return wasSucessful ? 0 : 1;
};
