/*
 * tesselation_insideoutsideunittest.cpp
 *
 *  Created on: Dec 28, 2009
 *      Author: heber
 */

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <cstring>

#include "defs.hpp"
#include "tesselation.hpp"
#include "tesselation_insideoutsideunittest.hpp"

#define SPHERERADIUS 2.

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( TesselationInOutsideTest );


void TesselationInOutsideTest::setUp()
{
  setVerbosity(2);

  // create corners
  class TesselPoint *Walker;
  Walker = new TesselPoint;
  Walker->node = new Vector(0., 0., 0.);
  Walker->Name = Malloc<char>(3, "TesselationInOutsideTest::setUp - *Name");
  strcpy(Walker->Name, "1");
  Walker->nr = 1;
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->node = new Vector(0., 1., 0.);
  Walker->Name = Malloc<char>(3, "TesselationInOutsideTest::setUp - *Name");
  strcpy(Walker->Name, "2");
  Walker->nr = 2;
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->node = new Vector(1., 0., 0.);
  Walker->Name = Malloc<char>(3, "TesselationInOutsideTest::setUp - *Name");
  strcpy(Walker->Name, "3");
  Walker->nr = 3;
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->node = new Vector(1., 1., 0.);
  Walker->Name = Malloc<char>(3, "TesselationInOutsideTest::setUp - *Name");
  strcpy(Walker->Name, "4");
  Walker->nr = 4;
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->node = new Vector(0., 0., 1.);
  Walker->Name = Malloc<char>(3, "TesselationInOutsideTest::setUp - *Name");
  strcpy(Walker->Name, "5");
  Walker->nr = 5;
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->node = new Vector(0., 1., 1.);
  Walker->Name = Malloc<char>(3, "TesselationInOutsideTest::setUp - *Name");
  strcpy(Walker->Name, "6");
  Walker->nr = 6;
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->node = new Vector(1., 0., 1.);
  Walker->Name = Malloc<char>(3, "TesselationInOutsideTest::setUp - *Name");
  strcpy(Walker->Name, "7");
  Walker->nr = 7;
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->node = new Vector(1., 1., 1.);
  Walker->Name = Malloc<char>(3, "TesselationInOutsideTest::setUp - *Name");
  strcpy(Walker->Name, "8");
  Walker->nr = 8;
  Corners.push_back(Walker);

  // create linkedcell
  LinkedList = new LinkedCell(&Corners, 2.*SPHERERADIUS);

  // create tesselation
  TesselStruct = new Tesselation;
  TesselStruct->FindStartingTriangle(SPHERERADIUS, LinkedList);

  CandidateForTesselation *baseline = NULL;
  BoundaryTriangleSet *T = NULL;
  bool OneLoopWithoutSuccessFlag = true;
  bool TesselationFailFlag = false;
  while ((!TesselStruct->OpenLines.empty()) && (OneLoopWithoutSuccessFlag)) {
    // 2a. fill all new OpenLines
    Log() << Verbose(1) << "There are " << TesselStruct->OpenLines.size() << " open lines to scan for candidates:" << endl;
    for (CandidateMap::iterator Runner = TesselStruct->OpenLines.begin(); Runner != TesselStruct->OpenLines.end(); Runner++)
      Log() << Verbose(2) << *(Runner->second) << endl;

    for (CandidateMap::iterator Runner = TesselStruct->OpenLines.begin(); Runner != TesselStruct->OpenLines.end(); Runner++) {
      baseline = Runner->second;
      if (baseline->pointlist.empty()) {
        T = (((baseline->BaseLine->triangles.begin()))->second);
        Log() << Verbose(1) << "Finding best candidate for open line " << *baseline->BaseLine << " of triangle " << *T << endl;
        TesselationFailFlag = TesselStruct->FindNextSuitableTriangle(*baseline, *T, SPHERERADIUS, LinkedList); //the line is there, so there is a triangle, but only one.
      }
    }

    // 2b. search for smallest ShortestAngle among all candidates
    double ShortestAngle = 4.*M_PI;
    Log() << Verbose(1) << "There are " << TesselStruct->OpenLines.size() << " open lines to scan for the best candidates:" << endl;
    for (CandidateMap::iterator Runner = TesselStruct->OpenLines.begin(); Runner != TesselStruct->OpenLines.end(); Runner++)
      Log() << Verbose(2) << *(Runner->second) << endl;

    for (CandidateMap::iterator Runner = TesselStruct->OpenLines.begin(); Runner != TesselStruct->OpenLines.end(); Runner++) {
      if (Runner->second->ShortestAngle < ShortestAngle) {
        baseline = Runner->second;
        ShortestAngle = baseline->ShortestAngle;
        //Log() << Verbose(1) << "New best candidate is " << *baseline->BaseLine << " with point " << *baseline->point << " and angle " << baseline->ShortestAngle << endl;
      }
    }
    if ((ShortestAngle == 4.*M_PI) || (baseline->pointlist.empty()))
      OneLoopWithoutSuccessFlag = false;
    else {
      TesselStruct->AddCandidatePolygon(*baseline, SPHERERADIUS, LinkedList);
    }
  }
};


void TesselationInOutsideTest::tearDown()
{
  delete(LinkedList);
  delete(TesselStruct);
  for (LinkedCell::LinkedNodes::iterator Runner = Corners.begin(); Runner != Corners.end(); Runner++) {
    delete((*Runner)->node);
    delete(*Runner);
  }
  Corners.clear();
  MemoryUsageObserver::purgeInstance();
  logger::purgeInstance();
  errorLogger::purgeInstance();
};

/** UnitTest for Tesselation::IsInnerPoint()
 */
void TesselationInOutsideTest::IsInnerPointTest()
{
  double n[3];
  const double boundary = 2.;
  const double step = 1.;

  // go through the mesh and check each point
  for (n[0] = -boundary; n[0] <= boundary; n[0]+=step)
    for (n[1] = -boundary; n[1] <= boundary; n[1]+=step)
      for (n[2] = -boundary; n[2] <= boundary; n[2]+=step) {
        if ( ((n[0] >= 0.) && (n[1] >= 0.) && (n[2] >= 0.)) && ((n[0] <= 1.) && (n[1] <= 1.) && (n[2] <= 1.)))
          CPPUNIT_ASSERT_EQUAL( true , TesselStruct->IsInnerPoint(Vector(n[0], n[1], n[2]), LinkedList) );
        else
          CPPUNIT_ASSERT_EQUAL( false , TesselStruct->IsInnerPoint(Vector(n[0], n[1], n[2]), LinkedList) );
      }
};

/********************************************** Main routine **************************************/

int main(int argc, char **argv)
{
  // Get the top level suite from the registry
  CppUnit::Test *suite = CppUnit::TestFactoryRegistry::getRegistry().makeTest();

  // Adds the test to the list of test to run
  CppUnit::TextUi::TestRunner runner;
  runner.addTest( suite );

  // Change the default outputter to a compiler error format outputter
  runner.setOutputter( new CppUnit::CompilerOutputter( &runner.result(),
                                                       std::cerr ) );
  // Run the tests.
  bool wasSucessful = runner.run();

  // Return error code 1 if the one of test failed.
  return wasSucessful ? 0 : 1;
};
