/*
 * FormatParser_Parameters.hpp
 *
 *  Created on: Sep 5, 2011
 *      Author: heber
 */

#ifndef FORMATPARSER_PARAMETERS_HPP_
#define FORMATPARSER_PARAMETERS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Clone.hpp"

#include "Parser/Parameters/ParameterStorage.hpp"

class Parameter;

/** This class is an interface to the internal parameters of any FormatParser.
 *
 * We need this for undo/redoing LoadAction.
 *
 */
class FormatParser_Parameters : public Clone<FormatParser_Parameters>
{
public:
  FormatParser_Parameters();
  FormatParser_Parameters(const FormatParser_Parameters &_parameters);
  ~FormatParser_Parameters();

  // cloning
  FormatParser_Parameters* clone() const;
  void makeClone(const FormatParser_Parameters &_instance);

  // accessing parameters in storage
  void appendParameter(Parameter *instance);
  bool haveParameter(const std::string &_name) const;
  Parameter *getParameter(const std::string &_name) const;

protected:
  ParameterStorage *storage;
};


#endif /* FORMATPARSER_PARAMETERS_HPP_ */
