/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * WorkerAddressUnitTest.cpp
 *
 *  Created on: Feb 26, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

// include headers that implement a archive in simple text format
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "WorkerAddressUnitTest.hpp"

#include "WorkerAddress.hpp"

#include "CodePatterns/Assert.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( WorkerAddressTest );


void WorkerAddressTest::setUp()
{
  // Throw assertions
  ASSERT_DO(Assert::Throw);
}


void WorkerAddressTest::tearDown()
{
}

/** UnitTest for operator==
 */
void WorkerAddressTest::equalityTest()
{
  WorkerAddress address("testhost", "testport");
  WorkerAddress sameaddress("testhost", "testport");
  WorkerAddress otheraddress("othertesthost", "othertestport");

  CPPUNIT_ASSERT( address == sameaddress );
  CPPUNIT_ASSERT( address != otheraddress );
}

/** UnitTest for operator<
 */
void WorkerAddressTest::lessTest()
{
  WorkerAddress address("127.0.0.1", "123");
  WorkerAddress higherport("127.0.0.1", "124");
  WorkerAddress higherhost("127.0.0.2", "123");
  WorkerAddress higheraddress("127.0.0.2", "124");

  CPPUNIT_ASSERT( address < higherport );
  CPPUNIT_ASSERT( address < higherhost );
  CPPUNIT_ASSERT( address < higheraddress );
  CPPUNIT_ASSERT( higherport < higherhost );
  CPPUNIT_ASSERT( higherport < higheraddress );
  CPPUNIT_ASSERT( higherhost < higheraddress );
}

/** UnitTest for serialization
 */
void WorkerAddressTest::serializationTest()
{
  WorkerAddress address("testhost", "testport");
  // write element to stream
  std::stringstream stream;
  boost::archive::text_oarchive oa(stream);
  oa << address;

  //std::cout << "Contents of archive is " << stream.str() << std::endl;

  // create and open an archive for input
  boost::archive::text_iarchive ia(stream);
  // read class state from archive
  WorkerAddress otheraddress("othertesthost", "othertestport");

  ia >> otheraddress;

  // WorkerAddressStub is same as WorkerAddress contentwise, hence no casting required
  CPPUNIT_ASSERT (address == otheraddress);
}

