/*
 * WorkerAddress.hpp
 *
 *  Created on: 22.02.2012
 *      Author: heber
 */

#ifndef WORKERADDRESS_HPP_
#define WORKERADDRESS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "boost/serialization/access.hpp"
#include "boost/serialization/string.hpp"

#include <string>
#include <iosfwd>

/** WorkerAddress contains everything to connect to a listening Worker.
 *
 */
class WorkerAddress
{
public:
  WorkerAddress(const std::string &_host, const std::string &_service);
  ~WorkerAddress();

  bool operator<(const WorkerAddress &address) const;
  bool operator==(const WorkerAddress &address) const;
  bool operator!=(const WorkerAddress &address) const
  {
    return !(*this == address);
  }

  //!> host name of worker
  const std::string host;
  //!> port number on which worker listens
  const std::string service;

private:
  friend class boost::serialization::access;

  /** private default cstor for serialization only
   *
   */
  WorkerAddress();

  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & const_cast<std::string&>(host);
    ar & const_cast<std::string&>(service);
  }
};

std::ostream &operator<<(std::ostream &ost, const WorkerAddress &address);

#endif /* WORKERADDRESS_HPP_ */
