/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * WorkerAddress.cpp
 *
 *  Created on: 22.02.2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "WorkerAddress.hpp"

#include <iostream>

#include "CodePatterns/Log.hpp"

/** Constructor for class WorkerAddress.
 *
 * @param _host host name of this address
 * @param _service port number of this address
 */
WorkerAddress::WorkerAddress(const std::string& _host, const std::string& _service) :
  host(_host),
  service(_service)
{}

/** Destructor for class WorkerAddress.
 *
 */
WorkerAddress::~WorkerAddress()
{}

/** Output operator for WorkerAddress printing the address and priorty.
 *
 * @param ost output stream
 * @param address reference of WorkerAddress
 * @return output stream for concatenation
 */
std::ostream &operator<<(std::ostream &ost, const WorkerAddress &address)
{
  ost << address.host << ":" << address.service;
  return ost;
}

bool WorkerAddress::operator==(const WorkerAddress &address) const
{
  if (host != address.host) {
    LOG(2, "DEBUG: mismatch in host: " << host << " != " << address.host);
    return false;
  } else if (service != address.service) {
    LOG(2, "DEBUG: mismatch in service: " << service << " != " << address.service);
    return false;
  }
  return true;
}

bool WorkerAddress::operator<(const WorkerAddress &address) const
{
  if (host < address.host)
    return true;
  else if (host > address.host)
    return false;
  else if (service < address.service)
    return true;
  return false;
}
