/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ParameterStorage.cpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Parser/Parameters/ParameterStorage.hpp"
#include "CodePatterns/Registry_impl.hpp"

/** Constructor for class ParameterStorage.
 */
ParameterStorage::ParameterStorage()
{}

/** Copy constructor for class ParameterStorage.
 *
 * We need to make our own copy constructor as we have to clone all
 * stored parameters.
 *
 */
ParameterStorage::ParameterStorage(const ParameterStorage &_storage)
{
  for (const_iterator iter = _storage.getBeginIter(); iter != _storage.getEndIter(); ++iter) {
    Parameter *instance = (iter->second)->clone();
    registerInstance(instance);
  }
}

/** Destructor for class ParameterStorage.
 */
ParameterStorage::~ParameterStorage()
{
  cleanup();
}

CONSTRUCT_REGISTRY(Parameter)
