/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * InvertMoleculesAction.cpp
 *
 *  Created on: Mar 12, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/MoleculeDescriptor.hpp"
#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

#include "InvertMoleculesAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "InvertMoleculesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionInvertMoleculesAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  World::getInstance().invertMoleculeSelection();
  LOG(0, World::getInstance().countSelectedMolecules() << " molecules selected.");

  return Action::state_ptr(new SelectionInvertMoleculesState(params));
}

Action::state_ptr SelectionInvertMoleculesAction::performUndo(Action::state_ptr _state) {
  //SelectionInvertMoleculesState *state = assert_cast<SelectionInvertMoleculesState*>(_state.get());

  World::getInstance().invertMoleculeSelection();
  LOG(0, World::getInstance().countSelectedMolecules() << " molecules selected.");

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionInvertMoleculesAction::performRedo(Action::state_ptr _state){
  //SelectionInvertMoleculesState *state = assert_cast<SelectionInvertMoleculesState*>(_state.get());

  World::getInstance().invertMoleculeSelection();
  LOG(0, World::getInstance().countSelectedMolecules() << " molecules selected.");

  return Action::state_ptr(_state);
}

bool SelectionInvertMoleculesAction::canUndo() {
  return true;
}

bool SelectionInvertMoleculesAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
