/*
 * MoleculeDescriptorTest.hpp
 *
 *  Created on: Mar 4, 2010
 *      Author: crueger
 */

#ifndef MOLECULEDESCRIPTORTEST_HPP_
#define MOLECULEDESCRIPTORTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

#include "types.hpp"

#define MOLECULE_COUNT (10)

class molecule;

class MoleculeDescriptorTest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( MoleculeDescriptorTest );
  CPPUNIT_TEST ( MoleculeBaseSetsTest );
  CPPUNIT_TEST ( MoleculeIdTest );
  CPPUNIT_TEST ( MoleculeCalcTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void MoleculeBaseSetsTest();
  void MoleculeIdTest();
  void MoleculeCalcTest();

private:
  molecule *molecules [MOLECULE_COUNT];
  moleculeId_t moleculeIds [MOLECULE_COUNT];
};

#endif /* MOLECULEDESCRIPTORTEST_HPP_ */
