/*
 * CacheableTest.cpp
 *
 *  Created on: Feb 2, 2010
 *      Author: crueger
 */

#include "CacheableTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <boost/bind.hpp>

#include "Patterns/Cacheable.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( CacheableTest );

class threeNumbers : public Observable {
public:
  int x;
  int y;
  int z;
  Cacheable<int> sum;
  bool hasRecalced;

  void setX(int _x){
    OBSERVE;
    x = _x;
  }

  void setY
  (int _y){
    OBSERVE;
    y = _y;
  }

  void setZ(int _z){
    OBSERVE;
    z = _z;
  }

  int calcSum(){
    hasRecalced = true;
    return x+y+z;
  }

  threeNumbers(int _x,int _y, int _z) :
    x(_x),y(_y),z(_z),
    sum(this,boost::bind(&threeNumbers::calcSum,this)),
    hasRecalced(false)
  {}
};




void CacheableTest::setUp(){
  numbers = new threeNumbers(1,2,3);
}

void CacheableTest::tearDown(){
  delete numbers;
}

void CacheableTest::doesRecalcTest()
{
  CPPUNIT_ASSERT_EQUAL( 6, *(numbers->sum));
  CPPUNIT_ASSERT_EQUAL( true, numbers->hasRecalced);
  numbers->hasRecalced=false;
  numbers->setX(4);
  CPPUNIT_ASSERT_EQUAL( false, numbers->hasRecalced);
  CPPUNIT_ASSERT_EQUAL( 9, *(numbers->sum));
  CPPUNIT_ASSERT_EQUAL( true, numbers->hasRecalced);
}
