/*
 * QtMoleculeItemFactory.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEMFACTORY_HPP_
#define QTMOLECULEITEMFACTORY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QList>

#include <string>

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

#include "UIElements/Qt4/InstanceBoard/QtObservedMolecule.hpp"

/** This class is a factory for a list of QtMoleculeItem's.
 *
 * QtMoleculeList contains these per row, either a group item which combines
 * molecules of the same formula, or a molecule item which represents a single
 * molecule.
 */
struct QtMoleculeItemFactory
{

  static const int COLUMNCOUNT;
  static const char *COLUMNNAMES[];

  /** Creates all QtMoleculeItem's that make up the row for a single molecule.
   *
   * \param _ObservedMolecule observed representation of the molecule
   * \return list of prepared items to be appended to a group item
   */
  static QList<QStandardItem *> createMoleculeItems(
      QtObservedMolecule::ptr &_ObservedMolecule);

  /** Creates all QtMoleculeItem's that make up a row of a group item.
   *
   * \param _formula chemical formula which describes all molecules in this group
   * \return list of prepared items to be appended to the invisibleRootItem()
   */
  static QList<QStandardItem *> createGroupItems(const std::string &_formula);
};


#endif /* QTMOLECULEITEMFACTORY_HPP_ */
