/*
 * VerletIntegrationAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/VerletIntegrationAction.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

#include "atom.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "World.hpp"

/****** MoleculeVerletIntegrationAction *****/

// memento to remember the state when undoing

//class MoleculeVerletIntegrationState : public ActionState {
//public:
//  MoleculeVerletIntegrationState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeVerletIntegrationAction::NAME[] = "verlet-integrate";

MoleculeVerletIntegrationAction::MoleculeVerletIntegrationAction() :
  Action(NAME)
{}

MoleculeVerletIntegrationAction::~MoleculeVerletIntegrationAction()
{}

Action::state_ptr MoleculeVerletIntegrationAction::performCall() {
  string filename;
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  molecule *mol = NULL;

  dialog->queryString(NAME, &filename, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryMolecule("molecule-by-id", &mol, MapOfActions::getInstance().getDescription("molecule-by-id"));

  if(dialog->display()) {
    DoLog(1) && (Log() << Verbose(1) << "Parsing forces file and Verlet integrating." << endl);
    // TODO: sollte besser stream nutzen, nicht filename direkt (es sei denn, ist prefix), besser fuer unit test
    char outputname[MAXSTRINGSIZE];
    strcpy(outputname, filename.c_str());
    if (!mol->VerletForceIntegration(outputname, *(World::getInstance().getConfig())))
      DoLog(2) && (Log() << Verbose(2) << "File not found." << endl);
    else
      DoLog(2) && (Log() << Verbose(2) << "File found and parsed." << endl);

    delete dialog;
    return Action::success;
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr MoleculeVerletIntegrationAction::performUndo(Action::state_ptr _state) {
//  MoleculeVerletIntegrationState *state = assert_cast<MoleculeVerletIntegrationState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeVerletIntegrationAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeVerletIntegrationAction::canUndo() {
  return false;
}

bool MoleculeVerletIntegrationAction::shouldUndo() {
  return false;
}

const string MoleculeVerletIntegrationAction::getName() {
  return NAME;
}
