/*
 * SaveBondsAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/SaveBondsAction.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

#include "atom.hpp"
#include "bondgraph.hpp"
#include "config.hpp"
#include "defs.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "vector.hpp"
#include "verbose.hpp"
#include "World.hpp"

/****** MoleculeSaveBondsAction *****/

// memento to remember the state when undoing

//class MoleculeSaveBondsState : public ActionState {
//public:
//  MoleculeSaveBondsState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeSaveBondsAction::NAME[] = "save-bonds";

MoleculeSaveBondsAction::MoleculeSaveBondsAction() :
  Action(NAME)
{}

MoleculeSaveBondsAction::~MoleculeSaveBondsAction()
{}

Action::state_ptr MoleculeSaveBondsAction::performCall() {
  string filename;
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  molecule *mol = NULL;

  dialog->queryString(NAME, &filename, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryMolecule("molecule-by-id", &mol, MapOfActions::getInstance().getDescription("molecule-by-id"));

  if(dialog->display()) {
    DoLog(0) && (Log() << Verbose(0) << "Storing bonds to path " << filename << "." << endl);
    World::getInstance().getConfig()->BG->ConstructBondGraph(mol);
    // TODO: sollte stream, nicht filenamen direkt nutzen, beser fuer unit tests
    char outputname[MAXSTRINGSIZE];
    strcpy(outputname, filename.c_str());
    mol->StoreBondsToFile(NULL, outputname);
    delete dialog;
    return Action::success;
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr MoleculeSaveBondsAction::performUndo(Action::state_ptr _state) {
//  MoleculeSaveBondsState *state = assert_cast<MoleculeSaveBondsState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeSaveBondsAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSaveBondsAction::canUndo() {
  return false;
}

bool MoleculeSaveBondsAction::shouldUndo() {
  return false;
}

const string MoleculeSaveBondsAction::getName() {
  return NAME;
}
