/*
 * SaveAdjacencyAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/SaveAdjacencyAction.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

#include "atom.hpp"
#include "bondgraph.hpp"
#include "config.hpp"
#include "defs.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "vector.hpp"
#include "verbose.hpp"
#include "World.hpp"

/****** MoleculeSaveAdjacencyAction *****/

// memento to remember the state when undoing

//class MoleculeSaveAdjacencyState : public ActionState {
//public:
//  MoleculeSaveAdjacencyState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeSaveAdjacencyAction::NAME[] = "save-adjacency";

MoleculeSaveAdjacencyAction::MoleculeSaveAdjacencyAction() :
  Action(NAME)
{}

MoleculeSaveAdjacencyAction::~MoleculeSaveAdjacencyAction()
{}

Action::state_ptr MoleculeSaveAdjacencyAction::performCall() {
  string filename;
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  molecule *mol = NULL;

  dialog->queryString(NAME, &filename, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryMolecule("molecule-by-id", &mol, MapOfActions::getInstance().getDescription("molecule-by-id"));

  if(dialog->display()) {
    DoLog(0) && (Log() << Verbose(0) << "Storing adjacency to path " << filename << "." << endl);
    World::getInstance().getConfig()->BG->ConstructBondGraph(mol);
    // TODO: sollte stream nicht filename benutzen, besser fuer unit test
    char outputname[MAXSTRINGSIZE];
    strcpy(outputname, filename.c_str());
    mol->StoreAdjacencyToFile(NULL, outputname);
    delete dialog;
    return Action::success;
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr MoleculeSaveAdjacencyAction::performUndo(Action::state_ptr _state) {
//  MoleculeSaveAdjacencyState *state = assert_cast<MoleculeSaveAdjacencyState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeSaveAdjacencyAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSaveAdjacencyAction::canUndo() {
  return false;
}

bool MoleculeSaveAdjacencyAction::shouldUndo() {
  return false;
}

const string MoleculeSaveAdjacencyAction::getName() {
  return NAME;
}
