/*
 * LinearInterpolationofTrajectoriesAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/LinearInterpolationofTrajectoriesAction.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

#include "atom.hpp"
#include "defs.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "World.hpp"

/****** MoleculeLinearInterpolationofTrajectoriesAction *****/

// memento to remember the state when undoing

//class MoleculeLinearInterpolationofTrajectoriesState : public ActionState {
//public:
//  MoleculeLinearInterpolationofTrajectoriesState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeLinearInterpolationofTrajectoriesAction::NAME[] = "linear-interpolate";

MoleculeLinearInterpolationofTrajectoriesAction::MoleculeLinearInterpolationofTrajectoriesAction() :
  Action(NAME)
{}

MoleculeLinearInterpolationofTrajectoriesAction::~MoleculeLinearInterpolationofTrajectoriesAction()
{}

Action::state_ptr MoleculeLinearInterpolationofTrajectoriesAction::performCall() {
  string filename;
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  molecule *mol = NULL;
  int start = -1;
  int end = -1;
  bool IdMapping = true;


  dialog->queryString(NAME, &filename, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryInt("start-step", &start, MapOfActions::getInstance().getDescription("start-step"));
  dialog->queryInt("end-step", &end, MapOfActions::getInstance().getDescription("end-step"));
  dialog->queryMolecule("molecule-by-id", &mol, MapOfActions::getInstance().getDescription("molecule-by-id"));
  dialog->queryBoolean("id-mapping", &IdMapping, MapOfActions::getInstance().getDescription("id-mapping"));

  if(dialog->display()) {
    DoLog(1) && (Log() << Verbose(1) << "Linear interpolation between configuration " << start << " and " << end << "." << endl);
    if (IdMapping)
      DoLog(1) && (Log() << Verbose(1) << "Using Identity for the permutation map." << endl);
    char outputname[MAXSTRINGSIZE];
    strcpy(outputname, filename.c_str());
    // TODO: LinearInterpolationBetweenConfiguration should use stream, not the filename directly! (better for unit test)
    if (!mol->LinearInterpolationBetweenConfiguration(start, end, outputname, *(World::getInstance().getConfig()), IdMapping))
      DoLog(2) && (Log() << Verbose(2) << "Could not store " << outputname << " files." << endl);
    else
      DoLog(2) && (Log() << Verbose(2) << "Steps created and " << filename << " files stored." << endl);
    delete dialog;
    return Action::success;
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr MoleculeLinearInterpolationofTrajectoriesAction::performUndo(Action::state_ptr _state) {
//  MoleculeLinearInterpolationofTrajectoriesState *state = assert_cast<MoleculeLinearInterpolationofTrajectoriesState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeLinearInterpolationofTrajectoriesAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeLinearInterpolationofTrajectoriesAction::canUndo() {
  return false;
}

bool MoleculeLinearInterpolationofTrajectoriesAction::shouldUndo() {
  return false;
}

const string MoleculeLinearInterpolationofTrajectoriesAction::getName() {
  return NAME;
}
