/*
 * TranslateAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/TranslateAction.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

#include "atom.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "World.hpp"

/****** MoleculeTranslateAction *****/

// memento to remember the state when undoing

//class MoleculeTranslateState : public ActionState {
//public:
//  MoleculeTranslateState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeTranslateAction::NAME[] = "translate-mol";

MoleculeTranslateAction::MoleculeTranslateAction() :
  Action(NAME)
{}

MoleculeTranslateAction::~MoleculeTranslateAction()
{}

Action::state_ptr MoleculeTranslateAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  molecule *mol = NULL;
  Vector x;
  bool periodic = false;

  dialog->queryVector(NAME, &x, World::getInstance().getDomain(), false, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryMolecule("molecule-by-id", &mol, MapOfActions::getInstance().getDescription("molecule-by-id"));
  dialog->queryBoolean("periodic", &periodic, MapOfActions::getInstance().getDescription("periodic"));
  cout << "pre-dialog" << endl;

  if(dialog->display()) {
    cout << "post-dialog" << endl;
    DoLog(1) && (Log() << Verbose(1) << "Translating all ions by given vector." << endl);
    if (periodic)
      mol->TranslatePeriodically((const Vector *)&x);
    else
      mol->Translate((const Vector *)&x);
    delete dialog;
    return Action::success;
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr MoleculeTranslateAction::performUndo(Action::state_ptr _state) {
//  MoleculeTranslateState *state = assert_cast<MoleculeTranslateState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeTranslateAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeTranslateAction::canUndo() {
  return false;
}

bool MoleculeTranslateAction::shouldUndo() {
  return false;
}

const string MoleculeTranslateAction::getName() {
  return NAME;
}
