/*
 * SuspendInWaterAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/SuspendInWaterAction.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

#include "atom.hpp"
#include "boundary.hpp"
#include "config.hpp"
#include "log.hpp"
#include "config.hpp"
#include "World.hpp"

/****** MoleculeSuspendInWaterAction *****/

// memento to remember the state when undoing

//class MoleculeSuspendInWaterState : public ActionState {
//public:
//  MoleculeSuspendInWaterState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeSuspendInWaterAction::NAME[] = "suspend-in-water";

MoleculeSuspendInWaterAction::MoleculeSuspendInWaterAction() :
  Action(NAME)
{}

MoleculeSuspendInWaterAction::~MoleculeSuspendInWaterAction()
{}

Action::state_ptr MoleculeSuspendInWaterAction::performCall() {
  molecule *mol = NULL;
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  double density;
  double volume = 0.;

  dialog->queryMolecule(NAME, &mol, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryDouble("density", &density, MapOfActions::getInstance().getDescription("density"));

  if(dialog->display()) {
    DoLog(0) && (Log() << Verbose(0) << "Evaluating necessary cell volume for a cluster suspended in water.");
    if (density < 1.0) {
      DoeLog(1) && (eLog()<< Verbose(1) << "Density must be greater than 1.0g/cm^3!" << endl);
    } else {
      PrepareClustersinWater(World::getInstance().getConfig(), mol, volume, density);  // if volume == 0, will calculate from ConvexEnvelope
      delete dialog;
      return Action::success;
    }
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr MoleculeSuspendInWaterAction::performUndo(Action::state_ptr _state) {
//  MoleculeSuspendInWaterState *state = assert_cast<MoleculeSuspendInWaterState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeSuspendInWaterAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSuspendInWaterAction::canUndo() {
  return false;
}

bool MoleculeSuspendInWaterAction::shouldUndo() {
  return false;
}

const string MoleculeSuspendInWaterAction::getName() {
  return NAME;
}
