/*
 * SaveTemperatureAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/SaveTemperatureAction.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

#include "atom.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "World.hpp"

/****** MoleculeSaveTemperatureAction *****/

// memento to remember the state when undoing

//class MoleculeSaveTemperatureState : public ActionState {
//public:
//  MoleculeSaveTemperatureState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeSaveTemperatureAction::NAME[] = "save-temperature";

MoleculeSaveTemperatureAction::MoleculeSaveTemperatureAction() :
  Action(NAME)
{}

MoleculeSaveTemperatureAction::~MoleculeSaveTemperatureAction()
{}

Action::state_ptr MoleculeSaveTemperatureAction::performCall() {
  string filename;
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  molecule *mol = NULL;

  dialog->queryString(NAME, &filename, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryMolecule("molecule-by-id", &mol, MapOfActions::getInstance().getDescription("molecule-by-id"));

  if(dialog->display()) {
    DoLog(1) && (Log() << Verbose(1) << "Storing temperatures in " << filename << "." << endl);
    ofstream output;
    output.open(filename.c_str(), ios::trunc);
    if (output.fail() || !mol->OutputTemperatureFromTrajectories((ofstream * const) &output, 0, mol->MDSteps))
      DoLog(2) && (Log() << Verbose(2) << "File could not be written." << endl);
    else
      DoLog(2) && (Log() << Verbose(2) << "File stored." << endl);
    output.close();
    delete dialog;
    return Action::success;
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr MoleculeSaveTemperatureAction::performUndo(Action::state_ptr _state) {
//  MoleculeSaveTemperatureState *state = assert_cast<MoleculeSaveTemperatureState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeSaveTemperatureAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSaveTemperatureAction::canUndo() {
  return false;
}

bool MoleculeSaveTemperatureAction::shouldUndo() {
  return false;
}

const string MoleculeSaveTemperatureAction::getName() {
  return NAME;
}
