/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * TranslateAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Log.hpp"
#include "atom.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "Actions/AtomAction/TranslateAction.hpp"

// and construct the stuff
#include "TranslateAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr AtomTranslateAction::performCall() {
  Box &domain = World::getInstance().getDomain();
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  // obtain information
  getParametersfromValueStorage();

  // TODO: use AtomSet::translate
  for (std::vector<atom *>::iterator iter = selectedAtoms.begin(); iter != selectedAtoms.end(); ++iter) {
    *(*iter) += params.x;
    if (params.periodic)
      (*iter)->setPosition(domain.WrapPeriodically((*iter)->getPosition()));
  }

  return Action::state_ptr(new AtomTranslateState(selectedAtoms, params));
}

Action::state_ptr AtomTranslateAction::performUndo(Action::state_ptr _state) {
  AtomTranslateState *state = assert_cast<AtomTranslateState*>(_state.get());
  Box &domain = World::getInstance().getDomain();

  for (std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter) {
    *(*iter) -= state->params.x;
    if (state->params.periodic)
      (*iter)->setPosition(domain.WrapPeriodically((*iter)->getPosition()));
  }

  return Action::state_ptr(_state);
}

Action::state_ptr AtomTranslateAction::performRedo(Action::state_ptr _state){
  AtomTranslateState *state = assert_cast<AtomTranslateState*>(_state.get());
  Box &domain = World::getInstance().getDomain();

  for (std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter) {
    *(*iter) += state->params.x;
    if (state->params.periodic)
      (*iter)->setPosition(domain.WrapPeriodically((*iter)->getPosition()));
  }

  return Action::state_ptr(_state);
}

bool AtomTranslateAction::canUndo() {
  return true;
}

bool AtomTranslateAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
