/*
 * NotAllMoleculesAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/NotAllMoleculesAction.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "atom.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionNotAllMoleculesState : public ActionState {
public:
  SelectionNotAllMoleculesState(std::vector<molecule*> selectedMolecules) :
    selectedMolecules(selectedMolecules)
  {}
  std::vector<molecule*> selectedMolecules;
};

const char SelectionNotAllMoleculesAction::NAME[] = "unselect-all-molecules";

SelectionNotAllMoleculesAction::SelectionNotAllMoleculesAction() :
  Action(NAME)
{}

SelectionNotAllMoleculesAction::~SelectionNotAllMoleculesAction()
{}

Dialog* SelectionNotAllMoleculesAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryEmpty(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionNotAllMoleculesAction::performCall() {
  std::vector<molecule *> selectedMolecules = World::getInstance().getSelectedMolecules();
  DoLog(1) && (Log() << Verbose(1) << "Unselecting all molecules." << endl);
  World::getInstance().clearMoleculeSelection();
  return Action::state_ptr(new SelectionNotAllMoleculesState(selectedMolecules));
}

Action::state_ptr SelectionNotAllMoleculesAction::performUndo(Action::state_ptr _state) {
  SelectionNotAllMoleculesState *state = assert_cast<SelectionNotAllMoleculesState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  for(std::vector<molecule *>::iterator iter = state->selectedMolecules.begin(); iter != state->selectedMolecules.end(); ++iter)
    World::getInstance().selectMolecule(*iter);

  return Action::state_ptr(new SelectionNotAllMoleculesState(state->selectedMolecules));
}

Action::state_ptr SelectionNotAllMoleculesAction::performRedo(Action::state_ptr _state){
  SelectionNotAllMoleculesState *state = assert_cast<SelectionNotAllMoleculesState*>(_state.get());

  World::getInstance().clearMoleculeSelection();

  return Action::state_ptr(new SelectionNotAllMoleculesState(state->selectedMolecules));
}

bool SelectionNotAllMoleculesAction::canUndo() {
  return true;
}

bool SelectionNotAllMoleculesAction::shouldUndo() {
  return true;
}

const string SelectionNotAllMoleculesAction::getName() {
  return NAME;
}
