/*
 * AllMoleculesAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/AllMoleculesAction.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "atom.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionAllMoleculesState : public ActionState {
public:
  SelectionAllMoleculesState(std::vector<molecule*> selectedMolecules) :
    selectedMolecules(selectedMolecules)
  {}
  std::vector<molecule*> selectedMolecules;
};

const char SelectionAllMoleculesAction::NAME[] = "select-all-molecules";

SelectionAllMoleculesAction::SelectionAllMoleculesAction() :
  Action(NAME)
{}

SelectionAllMoleculesAction::~SelectionAllMoleculesAction()
{}

Dialog* SelectionAllMoleculesAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryEmpty(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionAllMoleculesAction::performCall() {
  std::vector<molecule *> selectedMolecules = World::getInstance().getSelectedMolecules();
  DoLog(1) && (Log() << Verbose(1) << "Selecting all molecules." << endl);
  World::getInstance().selectAllMolecules(AllMolecules());
  return Action::state_ptr(new SelectionAllMoleculesState(selectedMolecules));
}

Action::state_ptr SelectionAllMoleculesAction::performUndo(Action::state_ptr _state) {
  SelectionAllMoleculesState *state = assert_cast<SelectionAllMoleculesState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  for(std::vector<molecule *>::iterator iter = state->selectedMolecules.begin(); iter != state->selectedMolecules.end(); ++iter)
    World::getInstance().selectMolecule(*iter);

  return Action::state_ptr(new SelectionAllMoleculesState(state->selectedMolecules));
}

Action::state_ptr SelectionAllMoleculesAction::performRedo(Action::state_ptr _state){
  SelectionAllMoleculesState *state = assert_cast<SelectionAllMoleculesState*>(_state.get());

  World::getInstance().selectAllMolecules(AllMolecules());

  return Action::state_ptr(new SelectionAllMoleculesState(state->selectedMolecules));
}

bool SelectionAllMoleculesAction::canUndo() {
  return true;
}

bool SelectionAllMoleculesAction::shouldUndo() {
  return true;
}

const string SelectionAllMoleculesAction::getName() {
  return NAME;
}
