/*
 * AllAtomsAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/AllAtomsAction.hpp"
#include "Descriptors/AtomDescriptor.hpp"
#include "atom.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionAllAtomsState : public ActionState {
public:
  SelectionAllAtomsState(std::vector<atom*> _selectedAtoms) :
    selectedAtoms(_selectedAtoms)
  {}
  std::vector<atom*> selectedAtoms;
};

const char SelectionAllAtomsAction::NAME[] = "select-all-atoms";

SelectionAllAtomsAction::SelectionAllAtomsAction() :
  Action(NAME)
{}

SelectionAllAtomsAction::~SelectionAllAtomsAction()
{}

Dialog* SelectionAllAtomsAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryEmpty(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionAllAtomsAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();
  DoLog(1) && (Log() << Verbose(1) << "Selecting all atoms." << endl);
  World::getInstance().selectAllAtoms(AllAtoms());
  return Action::state_ptr(new SelectionAllAtomsState(selectedAtoms));
}

Action::state_ptr SelectionAllAtomsAction::performUndo(Action::state_ptr _state) {
  SelectionAllAtomsState *state = assert_cast<SelectionAllAtomsState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(new SelectionAllAtomsState(state->selectedAtoms));
}

Action::state_ptr SelectionAllAtomsAction::performRedo(Action::state_ptr _state){
  SelectionAllAtomsState *state = assert_cast<SelectionAllAtomsState*>(_state.get());

  World::getInstance().selectAllAtoms(AllAtoms());

  return Action::state_ptr(new SelectionAllAtomsState(state->selectedAtoms));
}

bool SelectionAllAtomsAction::canUndo() {
  return true;
}

bool SelectionAllAtomsAction::shouldUndo() {
  return true;
}

const string SelectionAllAtomsAction::getName() {
  return NAME;
}
