/*
 * AtomicInfo.hpp
 *
 *  Created on: Aug 10, 2010
 *      Author: heber
 */

#ifndef ATOMICINFO_HPP_
#define ATOMICINFO_HPP_

class atom;
class element;
class molecule;
class Vector;

/** This is for storing and transfering the information contained within an atom.
 * This is needed for Undo/Redo operations of AtomActions.
 */
class AtomicInfo {
public:
  AtomicInfo();
  AtomicInfo(const atom &_atom);
  ~AtomicInfo();

  bool setAtom(atom &_atom) const;
  atomId_t getId() const;

  AtomicInfo& operator=(const AtomicInfo&);

private:
  Vector Position;
  const element * Type;
  Vector Velocity;
  const atom * Father;
  const molecule * Mol;
  atomId_t Id;
};


#endif /* ATOMICINFO_HPP_ */
