/*
 * ActionHistory.cpp
 *
 *  Created on: Mar 25, 2010
 *      Author: crueger
 */

#include "Helpers/MemDebug.hpp"

#include "ActionHistory.hpp"

#include <iostream>

#include "Patterns/Singleton_impl.hpp"
#include "Helpers/Assert.hpp"
#include "Helpers/MemDebug.hpp"

using namespace std;

ActionHistory::ActionHistory()
{}

ActionHistory::~ActionHistory()
{}

void ActionHistory::undoLast(){
  ASSERT(history.size(),"Undo performed when the undo-queue was empty");
  HistoryElement elem = history.back();
  history.pop_back();
  Action::state_ptr newState = elem.action->undo(elem.state);
  yrotsih.push_back(HistoryElement(elem.action,newState));
}
void ActionHistory::redoLast(){
  ASSERT(yrotsih.size(),"Redo performed when the redo-queue was empty");
  HistoryElement elem = yrotsih.back();
  yrotsih.pop_back();
  Action::state_ptr oldState = elem.action->redo(elem.state);
  history.push_back(HistoryElement(elem.action,oldState));
}

bool ActionHistory::hasUndo(){
  return history.size()>0;
}

bool ActionHistory::hasRedo(){
  return yrotsih.size()>0;
}

void ActionHistory::addElement(Action* action,Action::state_ptr state){
  yrotsih.clear();
  history.push_back(HistoryElement(action,state));
}

void ActionHistory::clear(){
  history.clear();
  yrotsih.clear();
}

void ActionHistory::init(){
  ActionHistory *hist = new ActionHistory();
  setInstance(hist);
  new UndoAction(hist);
  new RedoAction(hist);
}

CONSTRUCT_SINGLETON(ActionHistory)

/****************** Contained actions *******************/

const char ActionHistory::UndoAction::NAME[] = "undo";

ActionHistory::UndoAction::UndoAction(ActionHistory *_hist) :
  Action(NAME),
  hist(_hist)
{}

ActionHistory::UndoAction::~UndoAction(){}

bool ActionHistory::UndoAction::canUndo(){
  return false;
}

bool ActionHistory::UndoAction::shouldUndo(){
  return false;
}

bool ActionHistory::UndoAction::isActive(){
  return hist->hasUndo();
}

Dialog* ActionHistory::UndoAction::fillDialog(Dialog *dialog){
  ASSERT(dialog,"No Dialog given when filling action dialog");
  return dialog;
}

Action::state_ptr ActionHistory::UndoAction::performCall(){
  std::cout << "Undo" << std::endl;
  hist->undoLast();
  return Action::success;
}

Action::state_ptr ActionHistory::UndoAction::performUndo(Action::state_ptr){
  ASSERT(0,"Cannot undo an undo (should use redo for this");
  return Action::success;
}

Action::state_ptr ActionHistory::UndoAction::performRedo(Action::state_ptr){
  ASSERT(0,"Cannot redo an undo");
  return Action::success;
}

const char ActionHistory::RedoAction::NAME[] = "redo";

ActionHistory::RedoAction::RedoAction(ActionHistory *_hist) :
    Action(NAME),
    hist(_hist)
{}

ActionHistory::RedoAction::~RedoAction(){}

bool ActionHistory::RedoAction::canUndo(){
  return false;
}

bool ActionHistory::RedoAction::shouldUndo(){
  return false;
}

bool ActionHistory::RedoAction::isActive(){
  std::cout << "Redo" << std::endl;
  return hist->hasRedo();
}

Dialog* ActionHistory::RedoAction::fillDialog(Dialog *dialog){
  ASSERT(dialog,"No Dialog given when filling action dialog");
  return dialog;
}

Action::state_ptr ActionHistory::RedoAction::performCall(){
  hist->redoLast();
  return Action::success;
}

Action::state_ptr ActionHistory::RedoAction::performUndo(Action::state_ptr){
  ASSERT(0,"Cannot undo a redo (should use undo for this");
  return Action::success;
}

Action::state_ptr ActionHistory::RedoAction::performRedo(Action::state_ptr){
  ASSERT(0,"Cannot redo a redo");
  return Action::success;
}
