/*
 * ShapeUnittest.hpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#ifndef SHAPEUNITTEST_HPP_
#define SHAPEUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

class Shape;
class Vector;

#include "vector.hpp"

class ShapeUnittest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( ShapeUnittest) ;
  CPPUNIT_TEST ( baseShapesTest );
  CPPUNIT_TEST ( assignmentTest );
  CPPUNIT_TEST ( operatorTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void baseShapesTest();
  void assignmentTest();
  void operatorTest();

  // a lot of vectors.
  // these define all the edges of a box around -1 +1 on each axis
  // 0 is 0, 1 is 1 and 2 is -1
  Vector v000;
  Vector v100;
  Vector v200;
  Vector v010;
  Vector v110;
  Vector v210;
  Vector v020;
  Vector v120;
  Vector v220;
  Vector v001;
  Vector v101;
  Vector v201;
  Vector v011;
  Vector v111;
  Vector v211;
  Vector v021;
  Vector v121;
  Vector v221;
  Vector v002;
  Vector v102;
  Vector v202;
  Vector v012;
  Vector v112;
  Vector v212;
  Vector v022;
  Vector v122;
  Vector v222;
};

#endif /* SHAPEUNITTEST_HPP_ */
