/*
 * ClearAllAtomsAction.cpp
 *
 *  Created on: Aug 09, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/ClearAllAtomsAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Descriptors/AtomDescriptor.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionClearAllAtomsState : public ActionState {
public:
  SelectionClearAllAtomsState(std::vector<atom*> _selectedAtoms) :
    selectedAtoms(_selectedAtoms)
  {}
  std::vector<atom*> selectedAtoms;
};

const char SelectionClearAllAtomsAction::NAME[] = "clear-atom-selection";

SelectionClearAllAtomsAction::SelectionClearAllAtomsAction() :
  Action(NAME)
{}

SelectionClearAllAtomsAction::~SelectionClearAllAtomsAction()
{}

void SelectionClearAllAtoms() {
  ActionRegistry::getInstance().getActionByName(SelectionClearAllAtomsAction::NAME)->call(Action::NonInteractive);
};

Dialog* SelectionClearAllAtomsAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryEmpty(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionClearAllAtomsAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();
  DoLog(1) && (Log() << Verbose(1) << "Clearing atoms selection." << endl);
  World::getInstance().clearAtomSelection();
  return Action::state_ptr(new SelectionClearAllAtomsState(selectedAtoms));
}

Action::state_ptr SelectionClearAllAtomsAction::performUndo(Action::state_ptr _state) {
  SelectionClearAllAtomsState *state = assert_cast<SelectionClearAllAtomsState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(new SelectionClearAllAtomsState(state->selectedAtoms));
}

Action::state_ptr SelectionClearAllAtomsAction::performRedo(Action::state_ptr _state){
  SelectionClearAllAtomsState *state = assert_cast<SelectionClearAllAtomsState*>(_state.get());

  World::getInstance().clearAtomSelection();

  return Action::state_ptr(new SelectionClearAllAtomsState(state->selectedAtoms));
}

bool SelectionClearAllAtomsAction::canUndo() {
  return true;
}

bool SelectionClearAllAtomsAction::shouldUndo() {
  return true;
}

const string SelectionClearAllAtomsAction::getName() {
  return NAME;
}
