/*
 * ChangeElementAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AtomAction/ChangeElementAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "atom.hpp"
#include "element.hpp"
#include "Helpers/Log.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Helpers/Verbose.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

const char AtomChangeElementAction::NAME[] = "change-element";

AtomChangeElementAction::AtomChangeElementAction() :
  Action(NAME)
{}

AtomChangeElementAction::~AtomChangeElementAction()
{}

void AtomChangeElement(element *elemental) {
  ValueStorage::getInstance().setCurrentValue(AtomChangeElementAction::NAME, elemental);
  ActionRegistry::getInstance().getActionByName(AtomChangeElementAction::NAME)->call(Action::NonInteractive);
};

Dialog* AtomChangeElementAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryElement(NAME, ValueStorage::getInstance().getDescription(NAME));

return dialog;
}

Action::state_ptr AtomChangeElementAction::performCall() {
  atom *first = NULL;
  element *elemental = NULL;
  molecule *mol = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, elemental);

  for (World::AtomSelectionIterator iter = World::getInstance().beginAtomSelection(); iter != World::getInstance().endAtomSelection(); ++iter) {
    first = iter->second;
    DoLog(1) && (Log() << Verbose(1) << "Changing atom " << *first << " to element " << elemental->symbol << "." << endl);
    mol = first->getMolecule();
    first->removeFromMolecule(); // remove atom
    first->type = elemental;
    mol->AddAtom(first);  // add atom to ensure correctness of formula
  }
  return Action::success;
}

Action::state_ptr AtomChangeElementAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr AtomChangeElementAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool AtomChangeElementAction::canUndo() {
  return false;
}

bool AtomChangeElementAction::shouldUndo() {
  return false;
}

const string AtomChangeElementAction::getName() {
  return NAME;
}
