/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ActionHistory.cpp
 *
 *  Created on: Mar 25, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Actions/ActionHistory.hpp"

#include "Actions/ActionExceptions.hpp"

#include <iostream>

#include "CodePatterns/Singleton_impl.hpp"
#include "CodePatterns/Assert.hpp"

using namespace MoleCuilder;


ActionHistory::ActionHistory()
{
  Action::createStaticStateEntities();
}

ActionHistory::~ActionHistory()
{
  Action::removeStaticStateEntities();
}

void ActionHistory::undoLast(){
  ASSERT(history.size(),"Undo performed when the undo-queue was empty");
  HistoryElement elem = history.back();
  history.pop_back();
  Action::state_ptr newState = elem.action->undo(elem.state);
  if (newState == Action::failure)
    throw ActionFailureException() << ActionNameString(elem.action->getName());
  yrotsih.push_back(HistoryElement(elem.action,newState));
}
void ActionHistory::redoLast(){
  ASSERT(yrotsih.size(),"Redo performed when the redo-queue was empty");
  HistoryElement elem = yrotsih.back();
  yrotsih.pop_back();
  Action::state_ptr oldState = elem.action->redo(elem.state);
  if (oldState == Action::failure)
    throw ActionFailureException() << ActionNameString(elem.action->getName());
  history.push_back(HistoryElement(elem.action,oldState));
}

bool ActionHistory::hasUndo(){
  return history.size()>0;
}

bool ActionHistory::hasRedo(){
  return yrotsih.size()>0;
}

void ActionHistory::addElement(Action* action,Action::state_ptr state){
  yrotsih.clear();
  history.push_back(HistoryElement(action,state));
}

void ActionHistory::clear(){
  history.clear();
  yrotsih.clear();
}

void ActionHistory::init(){
  ActionHistory *hist = new ActionHistory();
  setInstance(hist);
}

CONSTRUCT_SINGLETON(ActionHistory)

/****************** Contained actions *******************/

