/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ExportGraph_ToFiles.cpp
 *
 *  Created on: 08.03.2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "ExportGraph_ToFiles.hpp"

#include "CodePatterns/Log.hpp"
#include "Fragmentation/Graph.hpp"
#include "Fragmentation/KeySet.hpp"
#include "MoleculeListClass.hpp"
#include "World.hpp"

/** Constructor for class ExportGraph_ToFiles.
 *
 * @param _graph instance of Graph containing keyset of each fragment
 */
ExportGraph_ToFiles::ExportGraph_ToFiles(const Graph &_graph) :
		ExportGraph(_graph)
{}

/** Actual implementation of the export to files function.
 *
 */
void ExportGraph_ToFiles::operator ()()
{
}

/** Internal helper to create from each keyset a molecule
 *
 */
void ExportGraph_ToFiles::prepareMolecule()
{
  // allocate memory for the pointer array and transmorph graphs into full molecular fragments
  MoleculeListClass *BondFragments = new MoleculeListClass(World::getPointer());
  size_t count = 0;
  for(Graph::iterator runner = TotalGraph.begin(); runner != TotalGraph.end(); runner++) {
    KeySet test = (*runner).first;
    LOG(2, "DEBUG: Fragment No." << (*runner).second.first << " with TEFactor "
    		<< (*runner).second.second << ".");
    BondFragments->insert(StoreFragmentFromKeySet(test, World::getInstance().getConfig()));
    ++count;
  }
  LOG(1, "INFO: " << count << "/" << BondFragments->ListOfMolecules.size()
  		<< " fragments generated from the keysets.");
}
