/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DiscreteParameterTest.cpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "DiscreteParameterTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Parameters/DiscreteParameter.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

using namespace std;

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( DiscreteParameterTest );


void DiscreteParameterTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

  for (int i=1; i<=3;++i) {
    ValidValues.push_back(i);
  }
}

void DiscreteParameterTest::tearDown()
{
  ValidValues.clear();
}

/************************************ tests ***********************************/

/** Unit test for comparator.
 *
 */
void DiscreteParameterTest::comparatorTest()
{
  // create instance
  DiscreteParameter<int> test("intParam", ValidValues);
  DiscreteParameter<int> samenamedsamevalued("intParam", ValidValues);
  DiscreteParameter<int> samenamedelsevalued("intParam", ValidValues);
  DiscreteParameter<int> elsenamedsamevalued("int2Param", ValidValues);
  DiscreteParameter<int> elsenamedelsevalued("int2Param", ValidValues);
  test.setValue(1);
  samenamedsamevalued.setValue(1);
  samenamedelsevalued.setValue(2);
  elsenamedsamevalued.setValue(1);
  elsenamedelsevalued.setValue(2);

  CPPUNIT_ASSERT( test == samenamedsamevalued );
  CPPUNIT_ASSERT( test != samenamedelsevalued );
  CPPUNIT_ASSERT( test != elsenamedsamevalued );
  CPPUNIT_ASSERT( test != elsenamedelsevalued );
}

/** Unit test for clone.
 *
 */
void DiscreteParameterTest::cloneTest()
{
  // create instance
  DiscreteParameter<int> test("intParam", ValidValues);

  // check that we throw because of unset parameter
#ifndef NDEBUG
  std::cout << "The following Assert failures are intended and do not indicate a failure of the test." << std::endl;
  CPPUNIT_ASSERT_THROW(test.clone(), Assert::AssertionFailure);
#endif

  // set parameter
  test.setValue(2);

  // is returned as Parameter but we can compare only in true class as
  // Parameter may also be a ContinuousParameter where comparison is nonsense
  DiscreteParameter<int> *instance = dynamic_cast< DiscreteParameter<int> *> (test.clone());

  // different places in memory
  CPPUNIT_ASSERT( &test != instance);

  // but same contents
  CPPUNIT_ASSERT( test == *instance);
}

