/*
 * UIFactory.hpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#ifndef UIFACTORY_HPP_
#define UIFACTORY_HPP_

class MainWindow;
class Dialog;

class MoleculeListClass;
class config;
class periodentafel;

struct menuPopulaters;
/**
 * Abstract Factory to create any kind of User interface object needed by the programm.
 *
 * The factory can be created and has to be set to a certain type upon creation. It will then
 * only create UIelements of that certain type, so that all UIElements match. This way different
 * UIs can be handled in a concise abstract way.
 */
class UIFactory
{

public:
  enum InterfaceTypes {Text};
  virtual ~UIFactory();

  /**
   * Produce some kind of main window, of whichever type was chosen when the factory was created
   */
  virtual MainWindow* makeMainWindow(menuPopulaters,MoleculeListClass *, config *, periodentafel *, char *)=0;

  /**
   * Produce a User Interaction Dialog, that can query values from the User.
   * Again the type is determined upon factory creation.
   */
  virtual Dialog* makeDialog()=0;

protected:
  UIFactory();

// singleton stuff
private:
  static UIFactory *theFactory;

public:
  /**
   * create a Factory of a certain type. From that moment on only those UIElements can be produced by the factory
   */
  static void makeUserInterface(InterfaceTypes type);

  /**
   * get the previously created factory
   */
  static UIFactory* get();

  /**
   * Destroy the created factory.
   *
   * Make sure that all UIElements that were created by the factory are destroyed before calling this method.
   */
  static void purgeInstance();
};

#endif /* UIFACTORY_HPP_ */
