/*
 * Process.cpp
 *
 *  Created on: Feb 17, 2010
 *      Author: crueger
 */

#include "Process.hpp"

using namespace std;

Process::Process(int _maxSteps, std::string _name, bool _doRegister) :
  Action(_name,_doRegister),
  maxSteps(_maxSteps),
  active(false),
  starts(false),
  stops(false)
{}

Process::~Process()
{
  // make sure everybody knows we have stoped
  stop();
}


bool Process::isActive(){
  return active;
}

bool Process::doesStart(){
  return starts;
}

bool Process::doesStop(){
  return stops;
}

int Process::getCurrStep(){
  OBSERVE;
  return currStep;
}

void Process::setCurrStep(int _currStep){
  currStep = _currStep;
}

float Process::getDoneRatio() {
  if(getMaxSteps())
    return ((float)getCurrStep()/(float)getMaxSteps())*100.0;
  else
    return 0;
}

int Process::getMaxSteps(){
  return maxSteps;
}

void Process::setMaxSteps(int _maxSteps){
  maxSteps = _maxSteps;
}

void Process::start(){
  starts = true;
  {
    // we forcibly sign on all observers
    set<Observer*>::iterator iter;
    for(iter=processObservers.begin();iter!=processObservers.end();++iter){
      this->signOn((*iter));
    }
  }
  // only this small part should be observed
  {
    OBSERVE;
    currStep=0;
  }
  starts = false;
  active = true;
}

void Process::step(){
  OBSERVE;
  currStep++;
}

void Process::stop(){
  active=false;
  stops = true;
  {
    OBSERVE;
    currStep=0;
  }
  {
    // when we are done we forcibly sign off all observers
    set<Observer*>::iterator iter;
    for(iter=processObservers.begin();iter!=processObservers.end();++iter){
      this->signOff((*iter));
    }
  }
  stops = false;
}

// static stuff

set<Observer*> Process::processObservers;

void Process::AddObserver(Observer *obs){
  processObservers.insert(obs);
}
void Process::RemoveObserver(Observer *obs){
  processObservers.erase(obs);
}

