/*
 * atom_bondedparticle.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

#ifndef ATOM_BONDEDPARTICLE_HPP_
#define ATOM_BONDEDPARTICLE_HPP_


using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fstream>
#include <list>

#include "atom_atominfo.hpp"
#include "atom_bondedparticleinfo.hpp"
#include "atom_observable.hpp"
#include "atom_particleinfo.hpp"
#include "atom_observable.hpp"

/****************************************** forward declarations *****************************/

class bond;

/********************************************** declarations *******************************/

class BondedParticle : 
    public BondedParticleInfo, 
    public virtual ParticleInfo, 
    public virtual AtomInfo, 
    public virtual AtomObservable 
{
public:
  BondedParticle();
  virtual ~BondedParticle();

  bond::ptr addBond(const unsigned int _step, BondedParticle* Partner);
  bond::ptr addBond(BondedParticle* Partner);
  void removeBond(const unsigned int _step, BondedParticle* Partner);
  void removeBond(BondedParticle* Partner);
  void removeBond(bond::ptr &binder);
  void removeAllBonds();
  void removeAllBonds(const unsigned int _step);
  bool IsBondedTo(const unsigned int _step, BondedParticle * const BondPartner) const;
  void ClearBondsAtStep(const unsigned int _step);
  int CountBonds() const;
  int CorrectBondDegree();
  void resetBondDegree();
  void OutputBondOfAtom(std::ostream &ost) const;
  void OutputBonds(ofstream * const BondFile) const;
  void OutputOrder(ofstream *file) const;

  std::ostream & operator << (std::ostream &ost) const;

protected:
  bool RegisterBond(const unsigned int _step, bond::ptr const Binder);
  bool UnregisterBond(const unsigned int _step, bond::ptr const Binder);

  int ContainsBondAtStep(bond::ptr Binder) const;

private:
  unsigned int findBondsStep(bond::ptr const Binder) const;
  BondList::const_iterator findBondPartnerAtStep(
      const unsigned int _step,
      BondedParticle * const Partner) const;
};

std::ostream & operator << (std::ostream &ost, const BondedParticle &a);

#endif /* ATOM_BONDEDPARTICLE_HPP_ */
